/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib;

import com.technicalitiesmc.lib.init.TKLibBlockTags;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tklib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TKLibEventHandler {
    private static final ThreadLocal<Player> COLLECT_DROPS_TARGET = new ThreadLocal();

    public static boolean validate(Player player, BlockState state) {
        return player.m_6144_() && state.m_204336_(TKLibBlockTags.WRENCH_BREAKS_INSTANTLY) && player.m_21205_().m_204117_(TKLibItemTags.TOOLS_WRENCH);
    }

    public static void quickBreak(ServerPlayer player, BlockPos pos) {
        BlockState state = player.m_183503_().m_8055_(pos);
        if (TKLibEventHandler.validate((Player)player, state)) {
            player.m_183503_().m_5898_((Player)player, 2001, pos, Block.m_49956_((BlockState)state));
            player.f_8941_.m_9280_(pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (TKLibEventHandler.validate(event.getPlayer(), event.getTargetBlock())) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getPlayer();
        if (TKLibEventHandler.validate(player, event.getState())) {
            float blockDestroySpeed = event.getState().m_60800_((BlockGetter)player.m_183503_(), event.getPos());
            event.setNewSpeed(0.98f * blockDestroySpeed * 30.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBeginBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (TKLibEventHandler.validate(player, event.getState())) {
            COLLECT_DROPS_TARGET.set(player);
        }
    }

    public static void onStopBreaking() {
        COLLECT_DROPS_TARGET.set(null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Player player = COLLECT_DROPS_TARGET.get();
            if (player != null) {
                ItemStack item = itemEntity.m_32055_().m_41777_();
                if (!player.m_150109_().m_36054_(item)) {
                    itemEntity.m_32045_(item);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onUseItem(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        if (event.getPlayer().m_6144_() && event.getItemStack().m_204117_(TKLibItemTags.TOOLS_WRENCH) && (state = event.getWorld().m_8055_(event.getPos())).m_204336_(TKLibBlockTags.WRENCH_SNEAK_COMPATIBLE)) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }
}

